/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.skins;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.ui.fonts.FontRepository;

@Singleton
public class GuiSkinRepository {
    private Skin uiSkin = new Skin(Gdx.files.internal("assets/ui-skins/libgdx-default/uiskin.json"));

    @Inject
    public GuiSkinRepository(FontRepository fontRepository) {
        BitmapFont bitmapFont = fontRepository.getDefaultFontForUI().getBitmapFont();
        this.uiSkin.add("default-font", bitmapFont);
        this.uiSkin.get(TextField.TextFieldStyle.class).font = bitmapFont;
        this.uiSkin.get(Label.LabelStyle.class).font = bitmapFont;
        this.uiSkin.get(CheckBox.CheckBoxStyle.class).font = bitmapFont;
        this.uiSkin.get(Window.WindowStyle.class).titleFont = bitmapFont;
        this.uiSkin.get(List.ListStyle.class).font = bitmapFont;
        this.uiSkin.get(SelectBox.SelectBoxStyle.class).font = bitmapFont;
        this.uiSkin.get(SelectBox.SelectBoxStyle.class).listStyle.font = bitmapFont;
        this.uiSkin.get(TextButton.TextButtonStyle.class).font = bitmapFont;
    }

    public Skin getDefault() {
        return this.uiSkin;
    }
}

